// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierOrders.model.order.Status', {

    extend: 'Ext.data.Model',
    snippets: {
        state0: ViisonCommonApp.getSnippet(
            'model/order/status/open',
            'backend/viison_pickware_erp_supplier_orders/main'
        ),
        state1: ViisonCommonApp.getSnippet(
            'model/order/status/sent_to_supplier',
            'backend/viison_pickware_erp_supplier_orders/main'
        ),
        state2: ViisonCommonApp.getSnippet(
            'model/order/status/dispatched_by_supplier',
            'backend/viison_pickware_erp_supplier_orders/main'
        ),
        state3: ViisonCommonApp.getSnippet(
            'model/order/status/partly_received',
            'backend/viison_pickware_erp_supplier_orders/main'
        ),
        state4: ViisonCommonApp.getSnippet(
            'model/order/status/completely_received',
            'backend/viison_pickware_erp_supplier_orders/main'
        ),
        state5: ViisonCommonApp.getSnippet(
            'model/order/status/canceled',
            'backend/viison_pickware_erp_supplier_orders/main'
        ),
    },
    fields: [
        { name: 'id', type: 'int' },
        { name: 'name', type: 'string' },
        {
            name: 'description',
            type: 'string',
            convert: function (value, record) {
                // Map the status to the respective description snippet
                var snippetKey = 'state' + record.get('id');
                if (typeof record.snippets[snippetKey] !== 'undefined') {
                    return record.snippets[snippetKey];
                }

                return value;
            },
        },
    ],

});
