// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierOrders.store.SourceWarehouses', {

    extend: 'Shopware.apps.ViisonPickwareERPSupplierOrders.store.TargetWarehouses',

    proxy: {
        type: 'ajax',
        api: {
            read: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPSupplierOrders/getSourceWarehouseList'),
        },
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
    },

    /**
     * @returns {Array}
     */
    getWarehouseIds: function () {
        var warehouseIds = [];

        this.each(function (warehouse) {
            if (warehouse.get('id') !== 0) {
                warehouseIds.push(warehouse.get('id'));
            }
        });

        return warehouseIds;
    },

    /**
     * @returns {Array}
     */
    getIdsOfWarehousesWhoseStockIsAvailableOnline: function () {
        var warehouseIds = [];

        this.each(function (warehouse) {
            if (warehouse.get('id') !== 0 && warehouse.get('stockAvailableForSale')) {
                warehouseIds.push(warehouse.get('id'));
            }
        });

        return warehouseIds;
    },

});
