// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierOrders.store.TargetWarehouses', {

    extend: 'Shopware.apps.ViisonPickwareERPWarehouseManagement.store.Warehouse',
    autoLoad: true,

    /**
     * @returns {Shopware.apps.ViisonPickwareERPWarehouseManagement.model.Warehouse|null}
     */
    getDefaultWarehouse: function () {
        var defaultWarehouseId = this.findBy(function (warehouse) {
            return warehouse.get('defaultWarehouse');
        });

        if (defaultWarehouseId === -1) {
            return null;
        }

        return this.getAt(defaultWarehouseId);
    },

});
