// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierOrders.view.detail.Attachments', {

    extend: 'Ext.container.Container',
    alias: 'widget.viison_pickware_erp_supplier_orders-detail-attachments',
    cls: 'viison_pickware_erp_supplier_orders-detail-attachments',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_supplier_orders/main',
    viisonConfigNamespace: 'ViisonPickwareERPSupplierOrders',

    layout: {
        type: 'hbox',
        align: 'stretch',
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('edit/attachments/title');
        this.uploadUrl = ViisonCommonApp.assembleBackendUrl('mediaManager/upload', {
            albumID: this.getViisonConfig('viisonSupplierOrderAttachmentsAlbumId'),
        });
        this.items = [
            this.createAttachmentsPanel(),
            this.createUploadPanel(),
        ];

        this.callParent(arguments);
    },

    /**
     * Creates a new grid panel for listing order attachments.
     *
     * @return Ext.grid.Panel
     */
    createAttachmentsPanel: function () {
        return {
            xtype: 'grid',
            cls: 'viison_pickware_erp_supplier_orders-main-list viison-common--grid has--vertical-lines has--no-borders',
            store: this.record.attachments(),
            flex: 1,
            bodyStyle: {
                border: 'none',
            },
            columns: [{
                header: this.getViisonSnippet('order/attachment/field/filename'),
                dataIndex: 'filename',
                flex: 1,
            }, {
                xtype: 'datecolumn',
                header: this.getViisonSnippet('order/attachment/field/date'),
                dataIndex: 'date',
                width: 160,
                format: 'd.m.Y H:i:s',
            }, {
                xtype: 'actioncolumn',
                hideable: false,
                align: 'center',
                width: 60,
                items: [{
                    iconCls: 'sprite-inbox-download',
                    action: 'downloadAttachment',
                    tooltip: this.getViisonSnippet('edit/attachments/tooltip/download'),
                    handler: function (grid, rowIndex) {
                        this.fireEvent('downloadAttachment', grid.getStore().getAt(rowIndex));
                    },
                    scope: this,
                }, {
                    iconCls: 'sprite-minus-circle',
                    action: 'deleteAttachment',
                    tooltip: this.getViisonSnippet('edit/attachments/tooltip/delete'),
                    handler: function (grid, rowIndex) {
                        this.fireEvent('deleteAttachment', this, grid.getStore().getAt(rowIndex));
                    },
                    scope: this,
                }],
            }],
        };
    },

    /**
     * Creates a new form containing a file selection field as well as a drag'n'drop
     * area for uploading order attachments.
     *
     * @return Ext.form.Panel
     */
    createUploadPanel: function () {
        return {
            xtype: 'form',
            title: this.getViisonSnippet('edit/attachments/upload/title'),
            header: false,
            width: 350,
            border: false,
            bodyPadding: 20,
            style: {
                border: 'none',
                'border-left': '1px solid #a4b5c0 !important',
            },
            layout: {
                type: 'vbox',
                align: 'stretch',
            },
            items: [{
                xtype: 'filefield',
                fieldLabel: this.getViisonSnippet('edit/attachments/upload/field_label'),
                buttonText: this.getViisonSnippet('edit/attachments/upload/button'),
                buttonOnly: false,
                margin: '0 0 10',
                anchor: '100%',
                labelWidth: 40,
                buttonConfig: {
                    iconCls: 'sprite-inbox-upload',
                    cls: 'small secondary',
                },
                listeners: {
                    afterrender: function (element) {
                        // Allow bulk upload
                        element.fileInputEl.dom.multiple = true;
                    },
                    change: function (field) {
                        this.fireEvent('uploadAttachment', field);
                    },
                    scope: this,
                },
            }, {
                xtype: 'html5fileupload',
                name: 'drop-zone',
                requestURL: this.uploadUrl,
                showInput: false,
                checkSize: false,
                checkType: false,
                checkAmount: false,
                enablePreviewImage: false,
                dropZoneText: this.getViisonSnippet('edit/attachments/upload/description'),
                padding: 0,
                flex: 1,
                listeners: {
                    fileUploaded: {
                        fn: function (operation) {
                            this.fireEvent('attachmentUploaded', this, operation);
                        },
                        scope: this,
                    },
                },
            }],
        };
    },

});
