// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierOrders.view.detail.SupplierAssignMessageBox', {
    extend: 'Ext.window.MessageBox',
    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],

    /**
     * @Override
     */
    constructor: function () {
        this.callParent(arguments);

        // Locale files only translate the button text of the message box
        // singelton Ext.Msg (= Ext.MessageBox), but not of the parent class
        // Ext.window.MessageBox. Hence we need to apply the translation
        // manually.
        this.buttonText = Ext.Msg.buttonText;
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.callParent(arguments);
        var supplierStore = this.initialConfig && this.initialConfig.supplierStore;

        // Apply shopware styling
        this.msg.allowHtml = true;
        this.bottomTb.addCls('shopware-toolbar');
        this.bottomTb.setUI('shopware-ui');
        Ext.each(this.msgButtons, function (button) {
            var cls = (button.itemId === 'ok' || button.itemId === 'yes') ? 'primary' : 'secondary';
            button.addCls(cls);
        });

        this.supplierAssing = Ext.create('Ext.form.field.ComboBox', {
            anchor: '100%',
            name: 'supplierAssign',
            store: supplierStore || Ext.create('Shopware.apps.ViisonPickwareERPSupplierManagement.store.Supplier'),
            pageSize: 10,
            editable: false,
            typeAhead: false,
            allowBlank: false,
            displayField: 'name',
            valueField: 'id',
            autoSelect: true,
            forceSelection: true,
            submitEmptyText: false,
            emptyText: ViisonCommonApp.getSnippet(
                'edit/article_assignment/no_supplier',
                'backend/viison_pickware_erp_supplier_orders/main'
            ),
        });

        this.promptContainer.add(this.supplierAssing);
    },
});
