// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierOrders.view.DetailCreate', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_pickware_erp_supplier_orders-create',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_supplier_orders/main',

    layout: {
        type: 'vbox',
        align: 'stretch',
    },
    autoShow: true,
    width: '90%',
    height: '90%',

    bodyStyle: {
        border: 'none !important',
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.items = [
            {
                xtype: 'viison_pickware_erp_supplier_orders-detail-configuration',
                itemId: 'configurationPanel',
            },
            {
                xtype: 'viison_common_hint_panel-show_hide_grid_columns_hint',
                hintId: this.alias[0].replace('widget.', '') + '--gid-hint',
                hasTopBorder: false,
                hasRightBorder: false,
                hasLeftBorder: false,
            },
            {
                flex: 1,
                xtype: 'viison_pickware_erp_supplier_orders-detail-article_assignment',
                itemId: 'articleAssignmentPanel',
                record: this.record,
                supplierStore: this.supplierStore,
                leftStore: this.leftArticleStore,
                rightStore: this.rightArticleStore,
            },
        ];

        this.callParent(arguments);
    },

});
