// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierOrders.view.DetailEdit', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_pickware_erp_supplier_orders-edit',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_supplier_orders/main',

    layout: 'fit',
    autoShow: true,
    width: '90%',
    height: '90%',

    bodyStyle: {
        border: 'none !important',
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.items = [{
            xtype: 'tabpanel',
            region: 'center',
            border: 0,
            items: [
                {
                    xtype: 'panel',
                    layout: {
                        type: 'vbox',
                        align: 'stretch',
                    },
                    title: this.getViisonSnippet('edit/base/title'),
                    items: [
                        {
                            xtype: 'viison_pickware_erp_supplier_orders-detail-configuration',
                            itemId: 'viison_pickware_erp_supplier_orders-detail-configuration',
                            targetWarehouse: this.record.getWarehouse(),
                            orderStatus: this.record.get('statusId'),
                        }, {
                            flex: 1,
                            xtype: 'viison_pickware_erp_supplier_orders-detail-article_assignment',
                            record: this.record,
                            supplierStore: this.supplierStore,
                            itemStatusStore: this.itemStatusStore,
                            leftStore: this.leftArticleStore,
                            rightStore: this.rightArticleStore,
                        },
                    ],
                }, {
                    xtype: 'viison_pickware_erp_supplier_orders-detail-attachments',
                    record: this.record,
                },
            ],
        }];

        this.callParent(arguments);
    },

});
