// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierOrders.view.Main', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_pickware_erp_supplier_orders-main',
    cls: 'viison_pickware_erp_supplier_orders-main has--viison-common--sidebar',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_supplier_orders/main',

    layout: 'border',
    autoShow: true,
    width: '80%',
    height: '80%',
    border: false,

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('window/title');
        this.items = [{
            xtype: 'viison_pickware_erp_supplier_orders-main-list',
            region: 'center',
            store: this.orderStore,
            warehouseStore: this.warehouseStore,
            orderStatusStore: this.orderStatusStore,
            paymentStatusStore: this.paymentStatusStore,
        }, {
            xtype: 'viison_pickware_erp_supplier_orders-main-sidebar',
            region: 'west',
            store: this.orderStore,
            warehouseStore: this.warehouseStore,
            orderStatusStore: this.orderStatusStore,
            paymentStatusStore: this.paymentStatusStore,
            supplierStore: this.supplierStore,
        }];

        this.callParent(arguments);
    },

});
