// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSupplierOrders.view.main.Sidebar', {

    extend: 'Ext.panel.Panel',
    alias: 'widget.viison_pickware_erp_supplier_orders-main-sidebar',
    cls: 'viison_pickware_erp_supplier_orders-main-sidebar viison-common--sidebar has--header-size-large',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_supplier_orders/main',

    border: false,
    style: {
        border: 'none',
        'border-right': '1px solid #a4b5c0 !important',
    },
    collapsed: false,
    collapsible: true,
    floatable: false,
    autoScroll: true,
    width: 400,

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('sidebar/title');

        this.items = this.createFilterForm();
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);
    },

    /**
     * Creates the form filter fields which displayed on the left hand of the supplier order list.
     *
     * @return [Ext.form.Panel]
     */
    createFilterForm: function () {
        var supplierStore = Ext.create('Shopware.apps.ViisonPickwareERPSupplierManagement.store.Supplier', {
            pageSize: 10,
        });
        supplierStore.load();

        this.filterForm = Ext.create('Ext.form.Panel', {
            border: false,
            bodyStyle: {
                padding: 0,
            },
            cls: 'viison_pickware_erp_supplier_orders-filter-form',
            defaults: {
                xtype: 'pagingcombo',
                anchor: '100%',
                labelWidth: 100,
                minWidth: 250,
            },
            items: [
                {
                    xtype: 'label',
                    text: this.getViisonSnippet('sidebar/group/title/created'),
                    cls: 'is--group-header is--first',
                },
                {
                    xtype: 'datefield',
                    name: 'createdFrom',
                    fieldLabel: this.getViisonSnippet('sidebar/field/label/from'),
                    submitFormat: 'd.m.Y',
                },
                {
                    xtype: 'datefield',
                    name: 'createdTo',
                    fieldLabel: this.getViisonSnippet('sidebar/field/label/to'),
                    submitFormat: 'd.m.Y',
                },
                {
                    xtype: 'label',
                    text: this.getViisonSnippet('sidebar/group/title/delivery_date'),
                    cls: 'is--group-header',
                },
                {
                    xtype: 'datefield',
                    name: 'deliveryDateFrom',
                    fieldLabel: this.getViisonSnippet('sidebar/field/label/from'),
                    submitFormat: 'd.m.Y',
                },
                {
                    xtype: 'datefield',
                    name: 'deliveryDateTo',
                    fieldLabel: this.getViisonSnippet('sidebar/field/label/to'),
                    submitFormat: 'd.m.Y',
                },
                {
                    xtype: 'label',
                    text: this.getViisonSnippet('sidebar/group/title/payment_due_date'),
                    cls: 'is--group-header',
                },
                {
                    xtype: 'datefield',
                    name: 'paymentDueDateFrom',
                    fieldLabel: this.getViisonSnippet('sidebar/field/label/from'),
                    submitFormat: 'd.m.Y',
                },
                {
                    xtype: 'datefield',
                    name: 'paymentDueDateTo',
                    fieldLabel: this.getViisonSnippet('sidebar/field/label/to'),
                    submitFormat: 'd.m.Y',
                },
                {
                    xtype: 'label',
                    text: this.getViisonSnippet('sidebar/group/title/more_filters'),
                    cls: 'is--group-header',
                },
                {
                    xtype: 'combobox',
                    name: 'orderStatus',
                    queryMode: 'local',
                    store: this.orderStatusStore,
                    valueField: 'id',
                    displayField: 'description',
                    emptyText: this.getViisonSnippet('sidebar/combobox/empty_text/show_all'),
                    fieldLabel: this.getViisonSnippet('sidebar/field/label/order_status_selection'),
                },
                {
                    xtype: 'combobox',
                    name: 'paymentStatus',
                    queryMode: 'local',
                    store: this.paymentStatusStore,
                    valueField: 'id',
                    displayField: 'description',
                    emptyText: this.getViisonSnippet('sidebar/combobox/empty_text/show_all'),
                    fieldLabel: this.getViisonSnippet('sidebar/field/label/payment_status_selection'),
                },
                {
                    xtype: 'combobox',
                    name: 'supplier',
                    store: supplierStore,
                    valueField: 'id',
                    displayField: 'name',
                    pageSize: 10,
                    emptyText: this.getViisonSnippet('sidebar/combobox/empty_text/show_all'),
                    fieldLabel: this.getViisonSnippet('sidebar/field/label/supplier_selection'),
                },
                {
                    xtype: 'combobox',
                    name: 'warehouse',
                    store: this.warehouseStore,
                    valueField: 'id',
                    displayField: 'displayName',
                    emptyText: this.getViisonSnippet('sidebar/combobox/empty_text/show_all'),
                    fieldLabel: this.getViisonSnippet('sidebar/field/label/warehouse_selection'),
                },
            ],
        });

        return this.filterForm;
    },

    /**
     * Creates the "reset filters" and "perform filters" button which displayed in the filter options panel on
     * the left hand of the order list.
     *
     * @return {Ext.toolbar.Toolbar}
     */
    createDockedItems: function () {
        return Ext.create('Ext.toolbar.Toolbar', {
            dock: 'bottom',
            ui: 'shopware-ui is--viison-common--toolbar',
            items: [{
                xtype: 'button',
                cls: 'secondary',
                text: this.getViisonSnippet('sidebar/button/reset'),
                handler: function () {
                    this.fireEvent('resetFilters', this.filterForm);
                },
                scope: this,
            }, '->', {
                xtype: 'button',
                text: this.getViisonSnippet('sidebar/button/apply_filters'),
                cls: 'primary',
                handler: function () {
                    this.fireEvent('applyFilters', this.filterForm.getValues());
                },
                scope: this,
            }],
        });
    },

});
