// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPSystemInfo.view.systeminfo.Filelist', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_erp_systeminfo-systeminfo-filelist',
    cls: 'viison_pickware_erp_systeminfo-systeminfo-filelist viison-common--grid has--vertical-lines',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_system_info/main',

    autoScroll: true,
    style: {
        borderLeft: 'none !important',
        borderRight: 'none !important',
        borderBottom: 'none !important',
    },
    bodyStyle: {
        borderBottom: 'none !important',
    },

    listeners: {
        afterrender: function () {
            this.store.load();
        },
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.columns = this.getColumns();
        this.dockedItems = this.createDockedItems();

        // Create and load the ERP file store
        this.store = Ext.create('Shopware.apps.ViisonPickwareERPSystemInfo.store.File', {});
        this.store.on('load', function (store, records) {
            // Check for any missing or invalid files
            var numberOfFailedFiles = Ext.Array.filter(records, function (record) {
                return !record.get('result') || !record.get('available');
            });

            this.updateSummary(numberOfFailedFiles.length);
        }, this);

        this.callParent(arguments);
    },

    /**
     * @return Ext.grid.Column[]
     */
    getColumns: function () {
        return [
            {
                header: this.getViisonSnippet('file_grid/column/name'),
                dataIndex: 'name',
                flex: 1,
            }, {
                header: this.getViisonSnippet('file_grid/column/required'),
                dataIndex: 'available',
                tdCls: 'has--icon',
                width: 100,
                align: 'center',
                renderer: this.renderStatus,
            }, {
                header: this.getViisonSnippet('file_grid/column/status'),
                dataIndex: 'result',
                tdCls: 'has--icon',
                width: 65,
                align: 'center',
                renderer: this.renderStatus,
            },
        ];
    },

    /**
     * Creates the top toolbar containing the summary panel.
     *
     * @return {Ext.toolbar.Toolbar[]}
     */
    createDockedItems: function () {
        return {
            xtype: 'toolbar',
            dock: 'top',
            cls: 'is--summary-container',
            layout: 'fit',
            border: false,
            items: [{
                xtype: 'container',
                itemId: 'summary',
                cls: 'is--summary',
                html: this.getSummaryTemplate().apply({
                    numberOfFailedFiles: 0,
                }),
            }],
        };
    },

    /**
     * Updates the displayed summary based on a passed number of files for which the
     * check has failed.
     *
     * @param {Number} numberOfFailedFiles
     */
    updateSummary: function (numberOfFailedFiles) {
        this.down('#summary').el.dom.innerHTML = this.getSummaryTemplate().apply({
            numberOfFailedFiles: numberOfFailedFiles,
        });
    },

    /**
     * Returns the template used to render the summary.
     *
     * @returns {Ext.XTemplate}
     */
    getSummaryTemplate: function () {
        /* eslint-disable indent */
        return new Ext.XTemplate(
            '<tpl for=".">',
                '<tpl if="numberOfFailedFiles">',
                    '<span class="is--icon sprite-cross"></span>',
                    '<span>',
                        '{numberOfFailedFiles} ' + this.getViisonSnippet('text/discrepancy'),
                    '</span>',
                '<tpl else>',
                    '<span class="is--icon sprite-tick"></span>',
                    '<span>',
                        this.getViisonSnippet('text/no_discrepancy'),
                    '</span>',
                '</tpl>',
            '</tpl>'
        );
        /* eslint-enable indent */
    },

    /**
     * Function to render the status. 1 = a green tick, everything else = a red cross
     *
     * @param Number value
     * @return String
     */
    renderStatus: function (value) {
        var iconClass = (value) ? 'sprite-tick' : 'sprite-cross';

        return '<span class="is--icon ' + iconClass + '"></span>';
    },

});
