// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPWarehouseManagement.model.BinLocation', {

    extend: 'Ext.data.Model',
    fields: [
        { name: 'id', type: 'int' },
        { name: 'warehouseId', type: 'int' },
        { name: 'code', type: 'string' },
        { name: 'warehouse', type: 'auto' },
        {
            name: 'isNullBinLocation',
            type: 'boolean',
            defaultValue: false,
            convert: function (value, record) {
                return record.get('warehouse') && record.get('warehouse').nullBinLocationId === record.get('id');
            },
        },
    ],
    associations: [{
        type: 'hasOne',
        model: 'Shopware.apps.ViisonPickwareERPWarehouseManagement.model.Warehouse',
        associationKey: 'warehouse',
        name: 'warehouse',
        getterName: 'getWarehouse',
        setterName: 'setWarehouse',
    }],

});
