// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPWarehouseManagement.model.Warehouse', {

    extend: 'Ext.data.Model',
    fields: [
        { name: 'id', type: 'int' },
        { name: 'code', type: 'string' },
        { name: 'name', type: 'string' },
        { name: 'stockAvailableForSale', type: 'boolean', defaultValue: true },
        { name: 'defaultWarehouse', type: 'boolean', defaultValue: false },
        { name: 'defaultReturnShipmentWarehouse', type: 'boolean', defaultValue: false },
        { name: 'nullBinLocationId', type: 'int' },
        { name: 'contact', type: 'string' },
        { name: 'email', type: 'string' },
        { name: 'phone', type: 'string' },
        { name: 'address', type: 'string' },
        { name: 'comment', type: 'string' },
        // Pseudo field for easy access to a commonly used display name
        {
            name: 'displayName',
            convert: function (value, record) {
                if (typeof value !== 'undefined' && value !== '') {
                    // If a displayName is available, use it.
                    return value;
                }

                // Use default formatting otherwise
                return record.get('name') + ' (' + record.get('code') + ')';
            },
        },
    ],
    associations: [{
        type: 'hasMany',
        model: 'Shopware.apps.ViisonPickwareERPWarehouseManagement.model.BinLocation',
        associationKey: 'binLocations',
        name: 'binLocations',
        getterName: 'getBinLocations',
        setterName: 'setBinLocations',
    }, {
        type: 'hasMany',
        model: 'Shopware.apps.ViisonPickwareERPWarehouseManagement.model.BinLocationFormatComponent',
        associationKey: 'binLocationFormatComponents',
        name: 'binLocationFormatComponents',
        getterName: 'getBinLocationFormatComponents',
        setterName: 'setBinLocationFormatComponents',
    }],

});
