// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPWarehouseManagement.store.ArticleDetailMapping', {

    extend: 'Ext.data.Store',
    model: 'Shopware.apps.ViisonPickwareERPWarehouseManagement.model.ArticleDetailMapping',
    autoLoad: false,
    remoteFilter: true,
    remoteSort: true,
    sorters: [
        { property: 'articleDetail.number' },
    ],
    proxy: {
        type: 'ajax',
        batchActions: true,
        api: {
            read: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPWarehouseManagement/getBinLocationArticleDetailList'),
        },
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
    },

});
