// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPWarehouseManagement.store.BinLocation', {

    extend: 'Ext.data.Store',
    model: 'Shopware.apps.ViisonPickwareERPWarehouseManagement.model.BinLocation',
    autoLoad: false,
    remoteFilter: true,
    remoteSort: true,
    sorters: [
        { property: 'binLocation.warehouseId' },
        { property: 'binLocation.code' },
    ],
    proxy: {
        type: 'ajax',
        batchActions: true,
        api: {
            read: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPWarehouseManagement/getBinLocationList'),
            create: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPWarehouseManagement/createBinLocations'),
            update: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPWarehouseManagement/updateBinLocations'),
            destroy: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPWarehouseManagement/deleteBinLocations'),
        },
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
        writer: {
            type: 'json',
            root: 'data',
            allowSingle: false,
        },
    },

});
