// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPWarehouseManagement.view.BinLocationComboBox', {

    extend: 'Shopware.apps.ViisonCommonComboBox.view.ComboBox',
    alias: 'widget.viison_pickware_erp_warehouse_management-bin_location_combo_box',
    fieldLabel: ViisonCommonApp.getSnippet('bin_location_combobox/field_label', 'backend/viison_pickware_erp_warehouse_management/main'),
    emptyText: ViisonCommonApp.getSnippet('bin_location_combobox/empty_text', 'backend/viison_pickware_erp_warehouse_management/main'),
    changeEventName: 'binLocationChanged',
    pageSize: 10,

    /**
     * @Override
     */
    initComponent: function () {
        // Set customised templates that shows a dummy text for null bin locations
        var nullBinLocationSnippet = ViisonCommonApp.getSnippet(
            'bin_location_combobox/null_bin_location',
            'backend/viison_pickware_erp_warehouse_management/main'
        );
        /* eslint-disable indent */
        this.displayTpl = new Ext.XTemplate(
            '<tpl for=".">',
                '<tpl if="isNullBinLocation == true">',
                    nullBinLocationSnippet,
                '<tpl else>',
                    '{code}',
                '</tpl>',
            '</tpl>'
        );
        this.listConfig = {
            itemTpl: new Ext.XTemplate(
                '<tpl if="isNullBinLocation == true">',
                    '<i>' + nullBinLocationSnippet + '</i>',
                '<tpl else>',
                    '{code}',
                '</tpl>'
            ),
        };
        /* eslint-enable indent */

        // Create a bin location store
        this.store = Ext.create('Shopware.apps.ViisonPickwareERPWarehouseManagement.store.BinLocation', {
            pageSize: this.pageSize,
            sorters: [
                { property: 'binLocation.warehouseId', direction: 'ASC' },
                { property: 'isNullBinLocation', direction: 'ASC' },
                { property: 'articleDetailBinLocationMappings.defaultMapping', direction: 'DESC' },
                { property: 'binLocation.code', direction: 'ASC' },
            ],
        });

        this.callParent(arguments);

        // Load the store after calling the parent initializer
        this.loadStore();
    },

    /**
     * Updates the store's filters based on the configured warehouseId and articleDetailId and reloads the store using
     * the updated filter.
     */
    loadStore: function () {
        this.store.clearFilter(true);

        // Include warehouse data in the results
        this.store.getProxy().extraParams = this.store.getProxy().extraParams || {};
        this.store.getProxy().extraParams.includeWarehouseData = 1;

        // Since the filter was cleared, we need to set the limit manually (after we already set the pageSize of this
        // component).
        this.store.getProxy().extraParams.limit = this.pageSize;

        // Prepare the filters
        var filters = [];
        if (this.warehouseId) {
            filters.push({
                property: 'binLocation.warehouseId',
                value: this.warehouseId,
            });
        }
        if (this.articleDetailId) {
            filters.push({
                property: 'articleDetailBinLocationMappings.articleDetailId',
                value: this.articleDetailId,
            });

            // Include null bin locations in the results
            this.store.getProxy().extraParams.includeNullLocations = 1;
        } else {
            // Exclude null bin locations from the results
            this.store.getProxy().extraParams.includeNullLocations = 0;
        }

        this.store.filter(filters);
    },

});
