// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPWarehouseManagement.view.Edit', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_pickware_erp_warehouse_management-edit',
    stateId: 'viison_pickware_erp_warehouse_management-edit',

    layout: 'fit',
    autoShow: true,
    width: '90%',
    height: '90%',
    border: false,
    stateful: true,

    bodyStyle: {
        border: 'none !important',
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.items = [{
            xtype: 'tabpanel',
            region: 'center',
            cls: 'viison-common--tab-panel',
            items: [{
                xtype: 'viison_pickware_erp_warehouse_management-edit-base',
                record: this.record,
            }, {
                xtype: 'viison_pickware_erp_warehouse_management-edit-bin_locations',
                record: this.record,
                disabled: this.record.get('name').length === 0,
            }],
        }];

        this.callParent(arguments);
    },

});
