// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPWarehouseManagement.view.edit.Base', {

    extend: 'Ext.form.Panel',
    alias: 'widget.viison_pickware_erp_warehouse_management-edit-base',
    cls: 'viison_pickware_erp_warehouse_management-edit-base',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_warehouse_management/main',

    autoScroll: true,
    bodyStyle: 'border:none;',
    layout: {
        type: 'hbox',
        align: 'stretch',
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('edit/base/title');
        this.items = [
            this.createMasterDataGroup(),
            this.createAddressGroup(),
            this.createCommentGroup(),
        ];

        // Add the cancel and save buttons
        this.dockedItems = [{
            xtype: 'toolbar',
            dock: 'bottom',
            ui: 'shopware-ui is--viison-common--button-panel',
            items: [
                '->',
                {
                    text: this.getViisonSnippet('edit/base/toolbar/button/cancel'),
                    cls: 'secondary',
                    action: 'cancel',
                }, {
                    text: this.getViisonSnippet('edit/base/toolbar/button/save'),
                    cls: 'primary',
                    action: 'save',
                },
            ],
        }];

        this.callParent(arguments);

        // Fill form with record data
        this.loadRecord(this.record);
    },

    /**
     * @return Ext.form.FieldSet
     */
    createMasterDataGroup: function () {
        return Ext.create('Ext.form.FieldSet', {
            title: this.getViisonSnippet('edit/base/fieldset/master_data/title'),
            cls: 'is--viison-common--fieldset',
            flex: 5,
            margins: '0 5 0 5',
            defaults: {
                labelAlign: 'left',
                labelWidth: 125,
                anchor: '100%',
            },
            items: [{
                xtype: 'textfield',
                name: 'name',
                fieldLabel: this.getViisonSnippet('warehouse/field/name'),
                allowBlank: false,
            }, {
                xtype: 'textfield',
                name: 'code',
                fieldLabel: this.getViisonSnippet('warehouse/field/code'),
                allowBlank: false,
                style: 'margin-bottom:15px',
            }, {
                xtype: 'checkbox',
                name: 'stockAvailableForSale',
                cls: 'viison-common--checkbox-with-boxlabel',
                hideLabel: true,
                boxLabel: this.getViisonSnippet('warehouse/field/stock_available'),
                value: true,
            }, {
                xtype: 'checkbox',
                name: 'defaultWarehouse',
                cls: 'viison-common--checkbox-with-boxlabel',
                hideLabel: true,
                boxLabel: this.getViisonSnippet('warehouse/field/default_warehouse'),
                value: true,
                // Don't allow to unmark a warehouse as default, but only allow to
                // choose a new default
                disabled: this.record.get('defaultWarehouse'),
                helpText: (this.record.get('defaultWarehouse')) ? this.getViisonSnippet('edit/base/fieldset/master_data/help_text/default_warehouse') : null,
            }, {
                xtype: 'checkbox',
                name: 'defaultReturnShipmentWarehouse',
                cls: 'viison-common--checkbox-with-boxlabel',
                style: 'margin-bottom:25px',
                hideLabel: true,
                boxLabel: this.getViisonSnippet('warehouse/field/default_return_shipment_warehouse'),
                value: true,
                // Don't allow to unmark a warehouse as default, but only allow to
                // choose a new default
                disabled: this.record.get('defaultReturnShipmentWarehouse'),
                helpText: (this.record.get('defaultReturnShipmentWarehouse')) ? this.getViisonSnippet('edit/base/fieldset/master_data/help_text/default_return_shipment_warehouse') : null,
            }, {
                xtype: 'textfield',
                name: 'contact',
                fieldLabel: this.getViisonSnippet('warehouse/field/contact'),
            }, {
                xtype: 'textfield',
                name: 'email',
                fieldLabel: this.getViisonSnippet('warehouse/field/email'),
                vtype: 'email',
            }, {
                xtype: 'textfield',
                name: 'phone',
                fieldLabel: this.getViisonSnippet('warehouse/field/phone'),
            }],
        });
    },

    /**
     * @return Ext.form.FieldSet
     */
    createAddressGroup: function () {
        return Ext.create('Ext.form.FieldSet', {
            title: this.getViisonSnippet('warehouse/field/address'),
            flex: 3,
            cls: 'is--viison-common--fieldset is--sibling',
            margin: '0 5 0 0',
            layout: {
                type: 'vbox',
                align: 'stretch',
            },
            items: [{
                xtype: 'textareafield',
                name: 'address',
                height: 214,
            }, {
                xtype: 'box',
                cls: 'is--support-text',
                html: this.getViisonSnippet('edit/base/fieldset/address/info'),
            }],
        });
    },

    /**
     * @return Ext.form.FieldSet
     */
    createCommentGroup: function () {
        return Ext.create('Ext.form.FieldSet', {
            flex: 3,
            title: this.getViisonSnippet('warehouse/field/comment'),
            cls: 'is--viison-common--fieldset is--sibling',
            margin: '0 5 0 0',
            layout: {
                type: 'vbox',
                align: 'stretch',
            },
            items: [{
                xtype: 'textareafield',
                name: 'comment',
                height: 214,
            }, {
                xtype: 'box',
                cls: 'is--support-text',
                html: this.getViisonSnippet('edit/base/fieldset/comment/info'),
            }],
        });
    },

});
