// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPWarehouseManagement.view.edit.BinLocations', {

    extend: 'Ext.panel.Panel',
    alias: 'widget.viison_pickware_erp_warehouse_management-edit-bin_locations',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_warehouse_management/main',

    border: false,
    layout: {
        type: 'hbox',
        align: 'stretch',
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('edit/bin_locations/title');
        this.items = this.createItems();
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);
    },

    /**
     * @return Ext.component.Component[]
     */
    createItems: function () {
        // Create and load a bin location store
        var binLocationStore = Ext.create('Shopware.apps.ViisonPickwareERPWarehouseManagement.store.BinLocation', {
            filters: [
                { property: 'binLocation.warehouseId', value: this.record.get('id') },
            ],
        });
        binLocationStore.load();

        return [{
            xtype: 'viison_pickware_erp_warehouse_management-edit-bin_locations-bin_location_list',
            region: 'center',
            store: binLocationStore,
            flex: 1,
        }, {
            xtype: 'viison_pickware_erp_warehouse_management-edit-bin_locations-article_detail_mapping_list',
            region: 'east',
            store: Ext.create('Shopware.apps.ViisonPickwareERPWarehouseManagement.store.ArticleDetailMapping', {}),
            disabled: true,
            flex: 1,
        }];
    },

    /**
     * @return Ext.toolbar.Toolbar[]
     */
    createDockedItems: function () {
        return [{
            xtype: 'toolbar',
            dock: 'top',
            ui: 'shopware-ui is--viison-common--toolbar',
            items: [
                {
                    xtype: 'button',
                    text: this.getViisonSnippet('edit/bin_locations/toolbar/button/add_bin_location'),
                    iconCls: 'sprite-plus-circle-frame',
                    margin: '0 5 0 0',
                    action: 'addBinLocation',
                },
                {
                    xtype: 'button',
                    text: this.getViisonSnippet('edit/bin_locations/toolbar/button/generate_bin_locations'),
                    iconCls: 'sprite-attributes',
                    margin: '0 5 0 0',
                    action: 'generateBinLocations',
                },
                {
                    xtype: 'button',
                    text: this.getViisonSnippet('edit/bin_locations/toolbar/button/delete_selected_bin_locations'),
                    iconCls: 'sprite-minus-circle-frame',
                    margin: '0 5 0 0',
                    action: 'deleteSelectedBinLocations',
                    disabled: true,
                },
                '->',
                {
                    xtype: 'textfield',
                    name: 'searchfield',
                    cls: 'searchfield',
                    width: 170,
                    enableKeyEvents: true,
                    emptyText: this.getViisonSnippet('edit/bin_locations/toolbar/search_field/placeholder'),
                    listeners: {
                        buffer: 500,
                        scope: this,
                        change: function (field) {
                            this.fireEvent('searchFieldChanged', this, field.value);
                        },
                    },
                },
            ],
        }];
    },

});
