// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPWarehouseManagement.view.edit.BinLocations.ArticleDetailMappingList', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_erp_warehouse_management-edit-bin_locations-article_detail_mapping_list',
    cls: 'viison-common--grid has--no-borders has--vertical-lines',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_warehouse_management/main',

    split: true,
    border: false,
    autoScroll: true,
    viewConfig: {
        enableTextSelection: true,
        markDirty: false,
    },

    style: {
        borderLeft: '1px solid #a4b5c0 !important',
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.emptyText = this.getViisonSnippet('article_detail_mapping/empty_text');
        this.columns = this.createColumns();
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);
    },

    /**
     * @return Ext.grid.column.Column[]
     */
    createColumns: function () {
        return [{
            dataIndex: 'number',
            header: this.getViisonSnippet('article_detail_mapping/field/number'),
            width: 100,
        }, {
            dataIndex: 'name',
            header: this.getViisonSnippet('article_detail_mapping/field/name'),
            flex: 1,
        }, {
            dataIndex: 'stock',
            header: this.getViisonSnippet('article_detail_mapping/field/stock'),
            align: 'right',
            width: 75,
        }, {
            xtype: 'actioncolumn',
            width: 40,
            align: 'center',
            items: [{
                iconCls: 'sprite-sticky-notes-pin',
                action: 'showArticle',
                tooltip: this.getViisonSnippet('edit/bin_locations/article_detail_mapping_list/actions/show_article'),
                scope: this,
                handler: function (grid, rowIndex) {
                    this.fireEvent('showArticle', this, grid.getStore().getAt(rowIndex));
                },
            }],
        }];
    },

    /**
     * @return Ext.toolbar.Toolbar[]
     */
    createDockedItems: function () {
        return [{
            xtype: 'viison_common_pagination_toolbar-toolbar',
            store: this.store,
        }];
    },

});
