// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPWarehouseManagement.view.edit.BinLocations.BinLocationCreation', {

    extend: 'Ext.window.Window',
    alias: 'widget.viison_pickware_erp_warehouse_management-edit-bin_locations-bin_location_creation',
    cls: 'viison_pickware_erp_warehouse_management-edit-bin_locations-bin_location_creation viison-common--window has--no-border',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_warehouse_management/main',

    layout: 'fit',
    modal: true,
    width: 320,

    listeners: {
        afterrender: function () {
            // Autofocus textfield (set focus delayed, otherwise it will get lost)
            setTimeout(function () {
                this.down('#code').focus();
            }.bind(this), 100);
        },
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('edit/bin_location_creation/title');

        this.items = [{
            xtype: 'form',
            cls: 'is--form',
            border: false,
            layout: 'hbox',
            items: this.createFormItems(),
        }];
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);
    },

    /**
     * @return Ext.form.field.Field[]
     */
    createFormItems: function () {
        return [{
            xtype: 'label',
            cls: 'is--viison-common--label',
            text: this.getViisonSnippet('edit/bin_location_creation/form/field/code') + ':',
            margin: '7 10 0 0',
        }, {
            flex: 1,
            name: 'code',
            itemId: 'code',
            xtype: 'textfield',
            hideLabel: true,
            allowBlank: false,
        }];
    },

    /**
     * @return Ext.toolbar.Toolbar[]
     */
    createDockedItems: function () {
        return [{
            xtype: 'toolbar',
            dock: 'bottom',
            layout: {
                pack: 'center',
            },
            ui: 'shopware-ui is--viison-common--button-panel is--primary',
            items: [
                {
                    xtype: 'button',
                    text: this.getViisonSnippet('edit/bin_location_creation/toolbar/button/cancel'),
                    action: 'cancel',
                    cls: 'secondary',
                }, {
                    xtype: 'button',
                    text: this.getViisonSnippet('edit/bin_location_creation/toolbar/button/save'),
                    action: 'save',
                    cls: 'primary',
                },
            ],
        }];
    },

});
