// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPWarehouseManagement.view.edit.BinLocations.BinLocationList', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_erp_warehouse_management-edit-bin_locations-bin_location_list',
    cls: 'viison-common--grid has--no-borders has--vertical-lines',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_warehouse_management/main',

    split: true,
    border: false,
    autoScroll: true,
    viewConfig: {
        enableTextSelection: true,
        markDirty: false,
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.columns = this.createColumns();
        this.dockedItems = this.createDockedItems();
        this.plugins = this.createPlugins();

        // Init a grid selection model
        this.selModel = Ext.create('Ext.selection.CheckboxModel', {
            listeners: {
                scope: this,
                selectionchange: function (model, selection) {
                    this.fireEvent('binLocationSelectionChanged', this, selection);
                },
            },
        });

        // Add a listener on the store to pre-select a row, if the store contains only a single record
        this.store.on('refresh', function () {
            if (this.store.count() === 1) {
                this.selModel.select(this.store.first());
            }
        }, this);

        this.callParent(arguments);
    },

    /**
     * @return Ext.grid.column.Column[]
     */
    createColumns: function () {
        var actions = this.createActions();

        return [{
            dataIndex: 'code',
            header: this.getViisonSnippet('bin_location/field/code'),
            flex: 1,
            editor: {
                xtype: 'textfield',
                allowBlank: false,
            },
        }, {
            xtype: 'actioncolumn',
            width: (actions.length * 25) + 15,
            align: 'center',
            items: actions,
        }];
    },

    /**
     * @return Object[]
     */
    createActions: function () {
        return [{
            iconCls: 'sprite-minus-circle',
            action: 'deleteBinLocation',
            tooltip: this.getViisonSnippet('edit/bin_locations/bin_location_list/actions/delete_bin_location'),
            scope: this,
            handler: function (grid, rowIndex) {
                this.fireEvent('deleteBinLocation', this, grid.getStore().getAt(rowIndex));
            },
        }];
    },

    /**
     * @return Ext.toolbar.Toolbar[]
     */
    createDockedItems: function () {
        return [{
            xtype: 'viison_common_pagination_toolbar-toolbar',
            store: this.store,
        }];
    },

    /**
     * @return Ext.grid.plugin.Editing[]
     */
    createPlugins: function () {
        return [
            Ext.create('Ext.grid.plugin.RowEditing', {
                clicksToEdit: 2,
                autoCancel: true,
                listeners: {
                    scope: this,
                    edit: function (editor, event) {
                        this.fireEvent('saveBinLocation', this, event.record);
                    },
                },
            }),
        ];
    },

});
