// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPWarehouseManagement.view.Main', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_pickware_erp_warehouse_management-main',
    cls: 'has--viison-common--sidebar',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_warehouse_management/main',

    layout: 'border',
    autoShow: true,
    width: '80%',
    height: '80%',
    border: false,

    listeners: {
        afterrender: function () {
            // Apply max size constraints
            if (this.getWidth() > 1200) {
                this.setWidth(1200);
            }
        },
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('window/title');
        this.items = [{
            xtype: 'viison_pickware_erp_warehouse_management-main-list',
            region: 'center',
            store: this.warehouseStore,
        }, {
            xtype: 'viison_pickware_erp_warehouse_management-main-details',
            region: 'east',
        }];

        this.callParent(arguments);
    },

});
