// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPWarehouseManagement.view.main.Details', {

    extend: 'Ext.panel.Panel',
    alias: 'widget.viison_pickware_erp_warehouse_management-main-details',
    cls: 'viison-common--sidebar has--header-size-extra-large',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_warehouse_management/main',

    border: false,
    style: 'border-left:1px solid #a4b5c0;',
    collapsed: false,
    collapsible: true,
    floatable: false,
    autoScroll: true,
    width: 300,

    /**
     * @Override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('details/title');

        // Create the main view rendering the data
        this.dataView = Ext.create('Ext.Component', {
            tpl: this.getTemplate(),
        });

        this.items = [
            this.dataView,
        ];

        this.callParent(arguments);
    },

    /**
     * @return The template used to render warehouse details
     */
    getTemplate: function () {
        /* eslint-disable indent */
        return new Ext.XTemplate(
            '<tpl for=".">',
                '<tpl if="name">',
                    '<div class="has--single-line-labels">',
                        '<h1 class="has--border">',
                            '{name}',
                            '<tpl if="defaultWarehouse == true">',
                                ' (' + this.getViisonSnippet('details/default') + ')',
                            '</tpl>',
                        '</h1>',
                        '<p>',
                            '<label>',
                                this.getViisonSnippet('warehouse/field/code') + ':',
                            '</label>',
                            '<span>',
                                '<tpl if="code">',
                                    '{code}',
                                '<tpl else>',
                                    '-',
                                '</tpl>',
                            '</span>',
                        '</p>',
                        '<p>',
                            '<label>',
                                this.getViisonSnippet('warehouse/field/stock_available') + ':',
                            '</label>',
                            '<span>',
                                '<tpl if="stockAvailableForSale == true">',
                                    this.getViisonSnippet('details/yes'),
                                '<tpl else>',
                                    this.getViisonSnippet('details/no'),
                                '</tpl>',
                            '</span>',
                        '</p>',
                        '<p>',
                            '<label>',
                                this.getViisonSnippet('warehouse/field/contact') + ':',
                            '</label>',
                            '<span>',
                                '<tpl if="contact">',
                                    '{contact}',
                                '<tpl else>',
                                    '-',
                                '</tpl>',
                            '</span>',
                        '</p>',
                        '<p>',
                            '<label>',
                                this.getViisonSnippet('warehouse/field/email') + ':',
                            '</label>',
                            '<span>',
                                '<tpl if="email">',
                                    '{email}',
                                '<tpl else>',
                                    '-',
                                '</tpl>',
                            '</span>',
                        '</p>',
                        '<p>',
                            '<label>',
                                this.getViisonSnippet('warehouse/field/phone') + ':',
                            '</label>',
                            '<span>',
                                '<tpl if="phone">',
                                    '{phone}',
                                '<tpl else>',
                                    '-',
                                '</tpl>',
                            '</span>',
                        '</p>',
                        '<p>',
                            '<label>',
                                this.getViisonSnippet('warehouse/field/address') + ':',
                            '</label>',
                            '<span class="is--multiline">',
                                '<tpl if="address">',
                                    '{address}',
                                '<tpl else>',
                                    '-',
                                '</tpl>',
                            '</span>',
                        '</p>',
                        '<p>',
                            '<label>',
                                this.getViisonSnippet('warehouse/field/comment') + ':',
                            '</label>',
                                '<span class="is--multiline">',
                                    '<tpl if="comment">',
                                        '{comment}',
                                    '<tpl else>',
                                        '-',
                                    '</tpl>',
                                '</span>',
                        '</p>',
                    '</div>',
                '<tpl else>',
                    '<div class="is--empty-text">',
                        '<span class="is--headline">',
                            this.getViisonSnippet('warehouse/details/empty_text/header_text'),
                        '</span>',
                            this.getViisonSnippet('warehouse/details/empty_text/body_text'),
                    '</div>',
                '</tpl>',
            '</tpl>'
        );
        /* eslint-enable indent */
    },

});
