// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPWarehouseManagement.view.main.List', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_erp_warehouse_management-main-list',
    cls: 'viison_pickware_erp_warehouse_management-main-list viison-common--grid has--no-borders has--vertical-lines',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_warehouse_management/main',

    split: true,
    border: true,
    autoScroll: true,
    viewConfig: {
        enableTextSelection: true,
        markDirty: false,
    },

    /**
     * @Override
     */
    initComponent: function () {
        this.columns = this.createColumns();
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);
    },

    /**
     * @return Ext.grid.column.Column[]
     */
    createColumns: function () {
        // Create a function for getting snippets that's always bound to this component. We need this, because we cannot
        // bind an action item's `getClass()` method to `this`.
        var getSnippet = this.getViisonSnippet.bind(this);

        return [{
            dataIndex: 'code',
            header: this.getViisonSnippet('warehouse/field/code'),
            width: 100,
        }, {
            dataIndex: 'name',
            header: this.getViisonSnippet('warehouse/field/name'),
            flex: 1,
        }, {
            dataIndex: 'stockAvailableForSale',
            header: this.getViisonSnippet('warehouse/field/stock_available'),
            tdCls: 'is--icon-column',
            align: 'center',
            width: 200,
            renderer: this.createBooleanColumnRenderer(this.getViisonSnippet('warehouse/field/stock_available')),
        }, {
            dataIndex: 'defaultWarehouse',
            header: this.getViisonSnippet('warehouse/field/default_warehouse'),
            tdCls: 'is--icon-column',
            align: 'center',
            width: 150,
            renderer: this.createBooleanColumnRenderer(this.getViisonSnippet('warehouse/field/default_warehouse')),
        }, {
            dataIndex: 'defaultReturnShipmentWarehouse',
            header: this.getViisonSnippet('warehouse/field/default_return_shipment_warehouse'),
            tdCls: 'is--icon-column',
            align: 'center',
            width: 150,
            renderer: this.createBooleanColumnRenderer(this.getViisonSnippet('warehouse/field/default_return_shipment_warehouse')),
        }, {
            xtype: 'actioncolumn',
            align: 'center',
            width: 60,
            items: [{
                iconCls: 'sprite-pencil',
                action: 'editWarehouse',
                tooltip: this.getViisonSnippet('list/tooltip/edit'),
                scope: this,
                handler: function (grid, rowIndex) {
                    this.fireEvent('editWarehouse', grid.getStore().getAt(rowIndex));
                },
            }, {
                iconCls: 'sprite-minus-circle',
                action: 'deleteWarehouse',
                getClass: function (value, meta, record) {
                    if (record.get('defaultWarehouse')) {
                        this.items[1].tooltip = getSnippet('list/tooltip/delete/defaultWarehouse');

                        return 'is--disabled';
                    }

                    this.items[1].tooltip = getSnippet('list/tooltip/delete');

                    return '';
                },
                handler: function (grid, rowIndex) {
                    var record = grid.getStore().getAt(rowIndex);

                    if (!record.get('defaultWarehouse')) {
                        this.fireEvent('deleteWarehouse', record);
                    }
                }.bind(this),
            }],
        }];
    },

    /**
     * Creates a button toolbar located at the top as well as a paging toolbar located at the bottom.
     *
     * @return Ext.toolbar.Toolbar[]
     */
    createDockedItems: function () {
        // Create a toolbar located at the top, containing a button for creating a new warehouse
        var topToolbar = Ext.create('Ext.toolbar.Toolbar', {
            dock: 'top',
            ui: 'shopware-ui is--viison-common--toolbar',
            items: [
                {
                    xtype: 'button',
                    text: this.getViisonSnippet('list/toolbar/button/add'),
                    iconCls: 'sprite-plus-circle-frame',
                    action: 'addWarehouse',
                },
                '->',
                {
                    xtype: 'textfield',
                    name: 'searchfield',
                    cls: 'searchfield',
                    width: 170,
                    enableKeyEvents: true,
                    emptyText: this.getViisonSnippet('list/toolbar/search_field/placeholder'),
                    listeners: {
                        buffer: 500,
                        scope: this,
                        change: function (field) {
                            this.fireEvent('searchFieldChanged', field.value);
                        },
                    },
                },
            ],
        });

        // Create a paging toolbar located at the bottom
        var bottomToolbar = {
            xtype: 'viison_common_pagination_toolbar-toolbar',
            store: this.store,
        };

        return [
            topToolbar,
            bottomToolbar,
        ];
    },

    /**
     * @param string trueSnippet
     * @return function
     */
    createBooleanColumnRenderer: function (trueSnippet) {
        return function (value, metaData) {
            if (value) {
                // Add a Qtip to the cell
                metaData.tdAttr = 'data-qtip="<b>' + trueSnippet + '</b>"';
            }

            // Select the icon class and create a new element
            var iconCls = (value) ? 'sprite-tick' : 'sprite-cross';
            var tpl = new Ext.XTemplate('<span class="is--icon ' + iconCls + '"></span>');

            return tpl.html;
        };
    },

});
