// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPWarehouseManagement.view.WarehouseComboBox', {

    extend: 'Shopware.apps.ViisonCommonComboBox.view.ComboBox',
    alias: 'widget.viison_pickware_erp_warehouse_management-warehouse_combo_box',
    fieldLabel: ViisonCommonApp.getSnippet('warehouse_combobox/field_label', 'backend/viison_pickware_erp_warehouse_management/main'),
    emptyText: ViisonCommonApp.getSnippet('warehouse_combobox/empty_text', 'backend/viison_pickware_erp_warehouse_management/main'),
    changeEventName: 'warehouseChanged',

    autoLoadStore: true,

    /**
     * @Override
     */
    initComponent: function () {
        // Set customised templates that show the additional text if present
        var warehouseComboboxTpl = '{displayName}';
        /* eslint-disable indent */
        this.displayTpl = new Ext.XTemplate(
            '<tpl for=".">',
                warehouseComboboxTpl,
            '</tpl>'
        );
        /* eslint-enable indent */
        this.listConfig = {
            itemTpl: Ext.create('Ext.XTemplate', warehouseComboboxTpl),
        };

        if (!this.store) {
            // Create a warehouse store, which lists the default warehouse at the top
            this.store = Ext.create('Shopware.apps.ViisonPickwareERPWarehouseManagement.store.Warehouse', {
                pageSize: 2000,
                sorters: [
                    { property: 'warehouse.defaultWarehouse', direction: 'DESC' },
                    { property: 'warehouse.name' },
                ],
            });
        }

        this.callParent(arguments);

        if (this.autoLoadStore) {
            // Load the store after calling the parent initializer
            this.store.load();
        }
    },

});
