// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPWarehouseManagementBarcodeLabelPrinting.view.edit.BinLocations', {

    override: 'Shopware.apps.ViisonPickwareERPWarehouseManagement.view.edit.BinLocations',

    /**
     * @Override
     */
    createDockedItems: function () {
        var dockedItems = this.callParent(arguments);

        // Insert the barcode label printing button in the top toolbar
        dockedItems[0].items.splice(3, 0, {
            xtype: 'button',
            text: ViisonCommonApp.getSnippet(
                'edit/bin_locations/toolbar/button/save_all_bin_locations_for_barcode_label_printing',
                'backend/viison_pickware_erp_warehouse_management_barcode_label_printing/main'
            ),
            iconCls: 'sprite-barcode',
            action: 'saveBinLocationsForBarcodeLabelPrinting',
        });

        return dockedItems;
    },

});
