// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPWarehouseManagementBarcodeLabelPrinting.view.edit.BinLocations.BinLocationList', {

    override: 'Shopware.apps.ViisonPickwareERPWarehouseManagement.view.edit.BinLocations.BinLocationList',

    /**
     * @Override
     */
    createActions: function () {
        var actions = this.callParent(arguments);

        // Add action for saving the bin location for barcode label printing
        actions.push({
            iconCls: 'sprite-barcode',
            action: 'saveBinLocationsForBarcodeLabelPrinting',
            tooltip: ViisonCommonApp.getSnippet(
                'edit/bin_locations/bin_location_list/action/save_bin_location_for_barcode_label_printing/tooltip',
                'backend/viison_pickware_erp_warehouse_management_barcode_label_printing/main'
            ),
            scope: this,
            handler: function (grid, rowIndex) {
                this.fireEvent('saveBinLocationForBarcodeLabelPrinting', this, grid.getStore().getAt(rowIndex));
            },
        });

        return actions;
    },

});
