{* Base file for all barcode label templates. *}

{block name="css" append}
    {assign var=contentHeightInMillimeter value=($layout->cellHeightInMillimeters - $paddingInMillimeter.top - $paddingInMillimeter.bottom)}
    {assign var=contentWidthInMillimeter value=($layout->cellWidthInMillimeters - $paddingInMillimeter.left - $paddingInMillimeter.right)}
    {assign var=gutterInMillimeter value=1}

    <style type="text/css">
        .barcode-label {
            position: relative;
            width: {$layout->cellWidthInMillimeters}mm;
            height: {$layout->cellHeightInMillimeters}mm;
        }

        .barcode-label.is--layout-two-rows .barcode-label-container,
        .barcode-label.is--layout-three-rows .barcode-label-container,
        .barcode-label.is--layout-two-columns .barcode-label-container {
            display: block;
            position: absolute;
            width: {$contentWidthInMillimeter}mm;
            height: {($contentHeightInMillimeter - $gutterInMillimeter) / 2}mm;
            line-height: 1.2;
            word-wrap: break-word;
            overflow: hidden;
        }
        .barcode-label.is--layout-three-rows .barcode-label-container {
            height: {($contentHeightInMillimeter - 2 * $gutterInMillimeter) / 3}mm;
        }
        .barcode-label.is--layout-two-columns .barcode-label-container {
            width: {($contentWidthInMillimeter - $gutterInMillimeter) / 2}mm;
            height: {$contentHeightInMillimeter - $gutterInMillimeter / 2}mm;
        }

        .barcode-label-container.is--half-width {
            width: {($contentWidthInMillimeter - $gutterInMillimeter) / 2}mm !important;
        }
        .barcode-label-container.is--half-height {
            height: {($contentHeightInMillimeter - 2 * $gutterInMillimeter) / 2}mm !important;
        }
        .barcode-label-container.is--one-third-width {
            width: {($contentWidthInMillimeter - $gutterInMillimeter) / 3}mm !important;
        }
        .barcode-label-container.is--two-thirds-width {
            width: {($contentWidthInMillimeter - $gutterInMillimeter) / 3 * 2}mm !important;
        }

        .barcode-label-container.is--position-top {
            top: {$paddingInMillimeter.top}mm;
            left: {$paddingInMillimeter.left}mm;
        }

        .barcode-label-container.is--position-top-left {
            top: {$paddingInMillimeter.top}mm;
            left: {$paddingInMillimeter.left}mm;
        }

        .barcode-label-container.is--position-top-right {
            top: {$paddingInMillimeter.top}mm;
            left: {$paddingInMillimeter.left + ($contentWidthInMillimeter - $gutterInMillimeter) / 2 + $gutterInMillimeter}mm;
        }
        .barcode-label-container.is--position-top-right.is--one-third-width {
            top: {$paddingInMillimeter.top}mm;
            left: {$paddingInMillimeter.left + ($contentWidthInMillimeter - $gutterInMillimeter) / 3 * 2 + $gutterInMillimeter}mm;
        }
        .barcode-label-container.is--position-top-right.is--two-thirds-width {
            top: {$paddingInMillimeter.top}mm;
            left: {$paddingInMillimeter.left + ($contentWidthInMillimeter - $gutterInMillimeter) / 3 + $gutterInMillimeter}mm;
        }

        .barcode-label.is--layout-three-rows .barcode-label-container.is--position-middle {
            top: {($contentHeightInMillimeter - 2 * $gutterInMillimeter) / 3 + $gutterInMillimeter + $paddingInMillimeter.top}mm;
            left: {$paddingInMillimeter.left}mm;
        }

        .barcode-label.is--layout-three-rows .barcode-label-container.is--position-middle-left {
            top: {($contentHeightInMillimeter - 2 * $gutterInMillimeter) / 3 + $gutterInMillimeter + $paddingInMillimeter.top}mm;
            left: {$paddingInMillimeter.left}mm;
        }

        .barcode-label.is--layout-three-rows .barcode-label-container.is--position-middle-right {
            top: {($contentHeightInMillimeter - 2 * $gutterInMillimeter) / 3 + $gutterInMillimeter + $paddingInMillimeter.top}mm;
            left: {$paddingInMillimeter.left + ($contentWidthInMillimeter - $gutterInMillimeter) / 2 + $gutterInMillimeter}mm;
        }
        .barcode-label .barcode-label-container.is--position-middle-right.is--one-third-width {
            left: {$paddingInMillimeter.left + ($contentWidthInMillimeter - $gutterInMillimeter) / 3 * 2 + $gutterInMillimeter}mm;
        }
        .barcode-label .barcode-label-container.is--position-middle-right.is--two-thirds-width {
            left: {$paddingInMillimeter.left + ($contentWidthInMillimeter - $gutterInMillimeter) / 3 + $gutterInMillimeter}mm;
        }

        .barcode-label.is--layout-two-rows .barcode-label-container.is--position-bottom,
        .barcode-label.is--layout-three-rows .barcode-label-container.is--position-bottom {
            top: {$paddingInMillimeter.top + (($contentHeightInMillimeter - $gutterInMillimeter) / 2) + $gutterInMillimeter}mm;
            left: {$paddingInMillimeter.left}mm;
        }
        .barcode-label.is--layout-three-rows .barcode-label-container.is--position-bottom {
            top: {$paddingInMillimeter.top + 2 * (($contentHeightInMillimeter - 2 * $gutterInMillimeter) / 3) + 2 * $gutterInMillimeter}mm;
        }

        .barcode-label.is--layout-two-rows .barcode-label-container.is--position-bottom-left,
        .barcode-label.is--layout-three-rows .barcode-label-container.is--position-bottom-left,
        .barcode-label.is--layout-two-columns .barcode-label-container.is--position-bottom-left {
            top: {$paddingInMillimeter.top + (($contentHeightInMillimeter - $gutterInMillimeter) / 2) + $gutterInMillimeter}mm;
            left: {$paddingInMillimeter.left}mm;
        }
        .barcode-label.is--layout-three-rows .barcode-label-container.is--position-bottom-left {
            top: {$paddingInMillimeter.top + 2 * (($contentHeightInMillimeter - 2 * $gutterInMillimeter) / 3) + 2 * $gutterInMillimeter}mm;
        }

        .barcode-label.is--layout-two-rows .barcode-label-container.is--position-bottom-right,
        .barcode-label.is--layout-three-rows .barcode-label-container.is--position-bottom-right {
            top: {$paddingInMillimeter.top + (($contentHeightInMillimeter - $gutterInMillimeter) / 2) + $gutterInMillimeter}mm;
            left: {$paddingInMillimeter.left + ($contentWidthInMillimeter - $gutterInMillimeter) / 2 + $gutterInMillimeter}mm;
        }
        .barcode-label.is--layout-three-rows .barcode-label-container.is--position-bottom-right {
            top: {$paddingInMillimeter.top + 2 * (($contentHeightInMillimeter - 2 * $gutterInMillimeter) / 3) + 2 * $gutterInMillimeter}mm;
        }

        .barcode-label.is--layout-two-rows .barcode-label-container img,
        .barcode-label.is--layout-three-rows .barcode-label-container img {
            width: auto;
            height: auto;
            max-width: {$contentWidthInMillimeter}mm;
            max-height: {($contentHeightInMillimeter - $gutterInMillimeter) / 2}mm;
        }
        .barcode-label.is--layout-three-rows .barcode-label-container img {
            max-height: {($contentHeightInMillimeter - 2 * $gutterInMillimeter) / 3}mm;
        }

        .barcode-label-container img.is--barcode {
            max-height: none !important;
        }

        .barcode-label-container.is--half-width img {
            max-width: {($contentWidthInMillimeter - $gutterInMillimeter) / 2}mm !important;
        }
        .barcode-label-container.is--one-third-width img {
            max-width: {($contentWidthInMillimeter - $gutterInMillimeter) / 3}mm !important;
        }
        .barcode-label-container.is--two-thirds-width img {
            max-width: {($contentWidthInMillimeter - $gutterInMillimeter) / 3 * 2}mm !important;
        }

        .barcode-label.is--layout-two-rows .barcode-label-container img.is--barcode,
        .barcode-label.is--layout-three-rows .barcode-label-container img.is--barcode {
            width: {$contentWidthInMillimeter}mm;
        }
        .barcode-label.is--layout-two-rows .barcode-label-container img.is--stretchable-barcode {
            height: {($contentHeightInMillimeter - $gutterInMillimeter) / 2}mm;
        }
        .barcode-label.is--layout-three-rows .barcode-label-container img.is--stretchable-barcode {
            height: {($contentHeightInMillimeter - 2 * $gutterInMillimeter) / 3}mm;
        }
        /**
         * The following calculations are based on the asssumption that the barcode aspect ratio
         * is 1x1.
         */
        .barcode-label.is--layout-two-rows .barcode-label-container img.is--1x1-aspect-ratio-barcode {
            position: absolute;
            top: {($contentHeightInMillimeter - 2) / 2 - $contentWidthInMillimeter}mm;
        }
        .barcode-label.is--layout-three-rows .barcode-label-container img.is--1x1-aspect-ratio-barcode {
            position: absolute;
            top: {($contentHeightInMillimeter - 2) / 3 - $contentWidthInMillimeter}mm;
        }
        .barcode-label.is--layout-two-rows .barcode-label-container.is--half-width img.is--1x1-aspect-ratio-barcode {
            position: absolute;
            top: {($contentHeightInMillimeter - 2) / 2 - (($contentWidthInMillimeter - $gutterInMillimeter)) / 2}mm;
        }
        .barcode-label.is--layout-three-rows .barcode-label-container.is--half-width img.is--1x1-aspect-ratio-barcode {
            position: absolute;
            top: {($contentHeightInMillimeter - 2) / 3 - $contentWidthInMillimeter / 2}mm;
        }

        .barcode-label-container.is--half-width img.is--barcode,
        .barcode-label.is--layout-two-columns .barcode-label-container img {
            width: {($contentWidthInMillimeter - $gutterInMillimeter) / 2}mm !important;
        }

        .barcode-label.is--layout-two-columns .barcode-label-container img {
            height: {($contentHeightInMillimeter - $gutterInMillimeter) / 2}mm;
        }

        p {
            margin: 0;
            padding: 0;
        }
    </style>
{/block}
