{namespace name="backend/viison_pickware_erp_pick_list/document"}
{extends file="documents/index.tpl"}

{*
    In this templte you can access the following new variables:

    {$Shop}: (sub) shop of this order, entity of the Shopware model Shopware\Models\Shop\Shop
    {$Warehouse}: selected warehouse, entity of the model Shopware\CustomModels\ViisonPickwareERP\Warehouse\Warehouse
*}

{* Add style in first block possible *}
{block name="document_index_selectAdress" prepend}
    <style type="text/css">
        {block name="pick_list_styling"}

            div.signature {
                {$Containers.Signature.style}
            }

            div.info {
                {$Containers.Info.style}
            }

            td.checked  {
                border-left: 1px solid black;
                border-right: 1px solid black;
                border-bottom: 1px solid black;
                text-align: center;
            }

            td.quantity {
                font-weight: bold;
                font-size: 14px;
                border-bottom: 1px solid black;
            }

            td.bottom-lined {
                border-bottom: 1px solid black;
            }

            td.binLocation {
                padding-left: 5px;
                padding-right: 5px;
                border-left: 1px solid black;
                border-bottom: 1px solid black;
            }

            .header-subtitle {
                float: left;
                margin-bottom: 15px;
            }

            .larger-text {
                font-size: 25px;
            }

        {/block}
    </style>
{/block}

{block name="document_index_selectAdress"}{/block}

{* Sender and recipient *}
{block name="document_index_address"}
    <div style="float: left; width: 40%;">
        <div style="font-weight: bold; border-bottom: 5px solid white;">{s name="shippingAddress"}{/s}</div>
        {block name="pick_list_address_shipping"}
            {$User.shipping.company}<br />
            {$User.shipping.salutation|salutation}
            {if {config name="displayprofiletitle"}}
                {$User.shipping.title}<br />
            {/if}
            {$User.shipping.firstname} {$User.shipping.lastname}<br />
            {$User.shipping.street}<br />
            {if {config name=showAdditionAddressLine1}}
                {$User.shipping.additional_address_line1}<br />
            {/if}
            {if {config name=showAdditionAddressLine2}}
                {$User.shipping.additional_address_line2}<br />
            {/if}
            {if {config name=showZipBeforeCity}}
                {$User.shipping.zipcode} {$User.shipping.city}<br />
            {else}
                {$User.shipping.city} {$User.shipping.zipcode}<br />
            {/if}
            {if $User.shipping.state.shortcode}{$User.shipping.state.shortcode} - {/if}{$User.shipping.country.countryen}<br />
        {/block}
    </div>
    <div style="float: left; border-left: 1px solid black; padding-left: 20px;">
        <div style="font-weight: bold; border-bottom: 5px solid white;">{s name="invoiceAddress"}{/s}</div>
        {block name="pick_list_address_billing"}
            {$User.billing.company}<br />
            {$User.billing.salutation|salutation}
            {if {config name="displayprofiletitle"}}
                {$User.billing.title}<br />
            {/if}
            {$User.billing.firstname} {$User.billing.lastname}<br />
            {$User.billing.street}<br />
            {if {config name=showAdditionAddressLine1}}
                {$User.billing.additional_address_line1}<br />
            {/if}
            {if {config name=showAdditionAddressLine2}}
                {$User.billing.additional_address_line2}<br />
            {/if}
            {if {config name=showZipBeforeCity}}
                {$User.billing.zipcode} {$User.billing.city}<br />
            {else}
                {$User.billing.city} {$User.billing.zipcode}<br />
            {/if}
            {if $User.billing.state.shortcode}{$User.billing.state.shortcode} - {/if}{$User.billing.country.countryen}<br />
        {/block}
    </div>
{/block}

{* we have to bypass the <strong> tags around this block *}
{block name="document_index_head_right"} </strong>
    <strong>{s name="header/shopName"}{/s} {$Shop->getName()}</strong><br />
    {s name="header/date"}{/s} {$Document.date}<br />
    <br />
    {s name="header/customerNumber"}{/s} {$User.billing.customernumber}<br />
    {s name="header/orderNumber"}{/s} {$Order._order.ordernumber}<br />
    {s name="header/orderDate"}{/s} {$Order._order.ordertime|date_format:"d.m.Y"}<br />
<strong>{/block}

{* new title *}
{block name="document_index_head_bottom"}
    <span style="font-weight: bold; font-size: 20px;">{s name="title"}{/s} <span class="larger-text">{$Order._order.ordernumber}</span></span>
    <div class="header-subtitle" style="text-align: left; width: 50%; border-top: 10px solid white;">
        {s name="title/warehouse"}{/s} <strong>{$warehouse->getName()} ({$warehouse->getCode()})</strong>
    </div>
    <div class="header-subtitle" style="text-align: right; width: 47%;">
        {s name="title/pageCounter"}{/s}
    </div>
{/block}

{* Modify headers (remove some, add some) *}
{block name="document_index_table_head_pos"}
    <td align="left" width="15%" class="head" style="padding-left: 5px;"><strong>{s name="table/binlocation"}{/s}</strong></td>
{/block}
{block name="document_index_table_head_nr"}
    <td align="left" width="15%" class="head"><strong>{s name="table/article_number"}{/s}</strong></td>
{/block}
{block name="document_index_table_head_name"}
    <td align="left" width="50%" class="head"><strong>{s name="table/name"}{/s}</strong></td>
{/block}
{block name="document_index_table_head_quantity"}
    <td align="center" width="10%" class="head"><strong>{s name="table/quantity"}{/s}</strong></td>
{/block}
{block name="document_index_table_head_tax"}{/block}
{block name="document_index_table_head_price"}
    <td align="center" width="10%" class="head"><strong>{s name="table/checked"}{/s}</strong></td>
{/block}

{* Modify table content (remove some, add some) *}
{block name="document_index_table_pos"}
    {* The field {$position.binLocation} already contains the Code of the BinLocation *}
    <td align="left" width="15%" height="30" class="binLocation">{$position.binLocation}</td>
{/block}
{block name="document_index_table_nr"}
    <td align="left" width="15%" class="bottom-lined">{$position.articleordernumber|truncate:14:""}</td>
{/block}
{block name="document_index_table_name"}
    <td align="left" width="50%" class="bottom-lined">{$position.name}</td>
{/block}
{block name="document_index_table_quantity"}
    <td align="center" width="10%" class="quantity">{$position.quantity}</td>
{/block}
{block name="document_index_table_tax"}{/block}
{block name="document_index_table_price"}
    <td width="10%" class="checked"></td>
{/block}

{* Additional blocks *}
{block name="document_index_info_dispatch"}
    <div style="margin-top: 20px; width: 100%;">
        {block name="pick_list_info"}
            <div class="info">
                {if $Order._dispatch.name}
                    <p>{s name="selectedDispatch"}{/s} <strong>{$Order._dispatch.name}</strong></p>
                {/if}
                <p>{s name="selectedPayment"}{/s} <strong>{$Order._payment.description}</strong></p>
            </div>
        {/block}
        {block name="pick_list_signature"}
            <div class="signature">
                {$Containers.Signature.value}
            </div>
        {/block}
{/block}

{* clear some blocks *}
{block name="document_index_amount"}{/block}
{block name="document_index_info_net"}{/block}
{block name="document_index_info_voucher"}{/block}
{block name="document_index_info_currency"}{/block}
