<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes;

use Exception;
use Throwable;

/**
 * An Api Exception with a localized error message and an arbitrary http status code.
 *
 * The error message is localized by looking up a snippet based on the controller name and the message code passed in
 * constructor. The locale used is determined by the Accept-Language header of the active request, or the default locale
 * of the default shop if that fails.
 */
class ApiException extends Exception
{
    /**
     * The namespace of the exception snippet is by prepending 'api/' to the controller name
     */
    const NAMESPACE_PREFIX = 'api/';

    /** @var int */
    protected $httpStatus;

    /**
     * @param string $messageId the name of a snippet in the namespace as determined by prepending 'api/' to the
     * controller name
     * @param int $httpStatus an http status code to return from the API call
     * @param Throwable|null $previous
     */
    public function __construct($messageId, $httpStatus = 500, Throwable $previous = null)
    {
        parent::__construct($messageId, $httpStatus, $previous);
        $this->httpStatus = $httpStatus;
    }

    /**
     * @return int
     */
    public function getHttpStatus()
    {
        return $this->httpStatus;
    }
}
