<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Document\RenderingEngine;

use Shopware\Plugins\ViisonCommon\Classes\Document\PaperLayout;

interface RenderingEngine
{
    /**
     * Renders a given HTML document to the document format specified by the respective rendering engine (usually PDF).
     *
     * @param string $html The HTML to render
     * @param PaperLayout $paperLayout
     * @return string The rendered document
     */
    public function render($html, PaperLayout $paperLayout);
}
