<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Exceptions\FileSystemExceptions;

use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\LocalizableThrowable;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\MessageLocalization;

/**
 * Exception to use for all errors that can occur during file system access
 */
abstract class AbstractFileSystemException extends \Exception implements LocalizableThrowable
{
    use MessageLocalization;

    /**
     * @var string Full path to file or directory
     */
    protected $path;

    /**
     * @param string $message
     * @param string $path Full path of file or directory
     * @param \Exception|null $previousException
     */
    public function __construct($message, $path, \Exception $previousException = null)
    {
        parent::__construct($message, 0, $previousException);

        $this->setSnippetNamespace('exceptions/viison_common/file_system_exception');
        $this->setSnippetArguments([$path]);
        $this->path = $path;
    }

    /**
     * @return string Full path of file or directory
     */
    public function getPath()
    {
        return $this->path;
    }
}
