<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Plugins\SwagImportExport;

use Shopware\Plugins\ViisonCommon\Classes\Exceptions\Plugins\SwagImportExport\ImportExportException;

interface DbAdapterFactory
{
    /**
     * Creates and returns a new instance of the import/export DB adapter that matches the passed `$adapterType`.
     *
     * @param string $adapterType
     * @return AbstractDbAdapter
     * @throws ImportExportException Iff the passed `$adapterType` does not match any DB adapter of this plugin.
     */
    public function createDbAdapterOfType($adapterType);
}
