<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Subscribers;

/**
 * Since Showpares \Shopware_Components_TemplateMail is not hookable this Subscriber intercepts the
 * initialization of the TemplateMailFactory and initializes or own TemplateMailFactory which creates
 * our own TemplateMail componant that will be hookable.
 *
 * Use this subscriber by extending it and implement handleBeforeCreateMail to alter any mail as desired.
 *
 * @deprecated Subscribe the event
 *     "Shopware\Plugins\ViisonCommon\Components\TemplateMailServiceDecorator::createMail::before" instead.
 */
// phpcs:ignore VIISON.Classes.AbstractClassName -- Can't be renamed because of backwards compatibility
abstract class TemplateMailComponent extends AbstractBaseSubscriber
{
    /**
     * @see \Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base::getSubscribedEvents()
     */
    public static function getSubscribedEvents()
    {
        return [
            'Shopware\\Plugins\\ViisonCommon\\Components\\TemplateMailServiceDecorator::createMail::before' => 'onBeforeCreateMail',
        ];
    }

    /**
     * @param \Enlight_Hook_HookArgs $args
     */
    public function onBeforeCreateMail(\Enlight_Hook_HookArgs $args)
    {
        $this->handleBeforeCreateMail($args->get('mailModel'), $args);
    }

    /**
     * Main function to manipulate any mail that is about to be created (and sent).
     * $mailModelName is the email templates name field (e.g. "sNEWSLETTERCONFIRMATION").
     *
     * @param string $mailModelName
     * @param \Enlight_Hook_HookArgs $args
     * @return mixed
     */
    abstract public function handleBeforeCreateMail($mailModelName, \Enlight_Hook_HookArgs $args);
}
