<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes;

use Shopware_Components_Translation;

/**
 * Helper class to fetch Shopware's Translation service which is available as a service since SW 5.3.4 or must be
 * instantiated in Shopware versions before that.
 */
class TranslationServiceFactory
{
    /**
     * @return Shopware_Components_Translation
     */
    public static function createTranslationService()
    {
        $container = Shopware()->Container();
        if ($container->has('translation')) {
            return $container->get('translation');
        }

        return new Shopware_Components_Translation($container->get('dbal_connection'), $container);
    }
}
