<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation;

/**
 * Interface to make a Throwable translatable
 *
 * Use the service ExceptionTranslator to translate the Throwable.
 * This interface must always be implemented with a Throwable.
 *
 * @deprecated Use LocalizableThrowable instead
 */
interface TranslatableThrowable
{
    /**
     * The snippet namespace for the translation
     *
     * @return string
     */
    public function getSnippetNamespace();

    /**
     * The snippet name for the translation
     *
     * @return string
     */
    public function getSnippetName();
}
