<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Components\GlobalLocking;

use Doctrine\DBAL\DBALException;
use Exception;

/**
 * @deprecated see GlobalLockingService
 */
class GlobalLockingException extends Exception
{
    /**
     * @param string $lockId
     * @return self
     */
    public static function lockingTimedOut($lockId)
    {
        return new self(sprintf(
            'Failed to acquire database lock for ID "%s": The lock has been acquired by a different process for longer than expected.',
            $lockId
        ));
    }

    /**
     * @param string $lockId
     * @param DBALException $dbalException
     * @return self
     */
    public static function dbalException($lockId, DBALException $dbalException)
    {
        return new self(
            sprintf(
                'Failed to acquire database lock for ID "%s": The database operation failed with error: %s',
                $lockId,
                $dbalException->getMessage()
            ),
            0,
            $dbalException
        );
    }

    /**
     * @param string $lockId
     * @return GlobalLockingException
     */
    public static function getLockReturnedNull($lockId)
    {
        return new self(sprintf(
            'Failed to acquire database lock for ID "%s": The database query SELECT GET_LOCK() returned null.',
            $lockId
        ));
    }
}
