<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Components\GlobalLocking;

/**
 * @deprecated see GlobalLockingService
 */
class ReentrantLockMutex
{
    /**
     * @var string
     */
    private $lockId;

    /**
     * @var int
     */
    private $counter = 1;

    /**
     * @param string $lockId
     */
    public function __construct($lockId)
    {
        $this->lockId = $lockId;
    }

    /**
     * @return string
     */
    public function getLockId()
    {
        return $this->lockId;
    }

    /**
     * @return boolean true, if the mutex counter is zero. false otherwise.
     */
    public function canReleaseLock()
    {
        return $this->counter === 0;
    }

    /**
     * Increases the mutex counter by one.
     */
    public function acquire()
    {
        $this->counter += 1;
    }

    /**
     * Decreases the mutex counter by one.
     */
    public function free()
    {
        $this->counter -= 1;
    }
}
