<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Components\Migration;

/**
 * Contains the MigrationTranscript and every MigrationSet with executed migrations from each
 * MigrationService::execute()-call.
 */
class MigrationExecutionResult
{
    /**
     * @var MigrationTranscript
     */
    private $migrationTranscript;

    /**
     * @var MigrationSet[]
     */
    private $migrationSets;

    /**
     * @param MigrationTranscript $migrationTranscript
     * @param MigrationSet[] $migrationSets
     */
    public function __construct(MigrationTranscript $migrationTranscript, array $migrationSets)
    {
        $this->migrationTranscript = $migrationTranscript;
        $this->migrationSets = $migrationSets;
    }

    /**
     * @return MigrationTranscript
     */
    public function getMigrationTranscript()
    {
        return $this->migrationTranscript;
    }

    /**
     * @return MigrationSet[]
     */
    public function getMigrationSets()
    {
        return $this->migrationSets;
    }

    /**
     * @return bool
     */
    public function hasFailedMigrationSets()
    {
        foreach ($this->migrationSets as $migrationSet) {
            foreach ($migrationSet->getMigrations() as $migration) {
                if ($migration->canExecute() && $migration->getStatus() === ManifestedMigration::STATUS_FAILED) {
                    return true;
                }
            }
        }

        return false;
    }

    /**
     * @return \Exception[]
     */
    public function getExceptions()
    {
        $exceptions = [];
        foreach ($this->migrationSets as $migrationSet) {
            foreach ($migrationSet->getMigrations() as $migration) {
                if ($migration->getException() !== null) {
                    $exceptions[] = $migration->getException();
                }
            }
        }

        return $exceptions;
    }
}
