<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Components\SubApplicationLoading\SubApplicationBuilder;

use Shopware\Plugins\ViisonCommon\Components\SubApplicationLoading\SubApplicationCodeGenerator\SubApplicationCodeGeneratorFactoryService;
use Shopware\Plugins\ViisonCommon\Components\SubApplicationLoading\SubApplicationRegistry;

interface SubApplicationBuilder
{
    /**
     * Builds the SubApplication and registers it in the $subApplicationRegistry.
     *
     * @param SubApplicationRegistry $subApplicationRegistry
     * @param SubApplicationCodeGeneratorFactoryService $subApplicationCodeGeneratorFactory
     */
    public function registerInSubApplicationRegistry(
        SubApplicationRegistry $subApplicationRegistry,
        SubApplicationCodeGeneratorFactoryService $subApplicationCodeGeneratorFactory
    );

    /**
     * @return string The name of the SubApplication to build.
     */
    public function getSubApplicationName();
}
