<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

use Shopware\Plugins\ViisonCommon\Controllers\ViisonCommonBaseController;

class Shopware_Controllers_Backend_ViisonCommonCompatibilityCheck extends ViisonCommonBaseController
{
    /**
     * Returns all compatibility issues as message, which have been collected
     * by the compatibility check component.
     */
    public function getCompatibilityIssuesAction()
    {
        $this->View()->assign([
            'success' => true,
            'data' => $this->get('ViisonCommonCompatibilityCheck')->getCompatibilityIssuesAsMessage(false),
        ]);
    }
}
