<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

if (!class_exists('ViisonCommon_Plugin_BootstrapV4')) {
    require_once('PluginBootstrapV4.php');
}

use Shopware\Plugins\ViisonCommon\Classes\Installation\ConfigForm\InstallationHelper as ConfigFormInstallationHelper;
use Shopware\Plugins\ViisonCommon\Classes\Util\Localization as LocalizationUtil;

/**
 * Version 5 of the common plugin Bootstrap class. This version is based on ViisonCommon_Plugin_BootstrapV4 and provides
 * an extra method that updates the config form translations.
 *
 * This class needs to be manually loaded in the plugin:
 *
 * if (!class_exists('ViisonCommon_Plugin_BootstrapV5')) {
 *     require_once('ViisonCommon/PluginBootstrapV5.php');
 * }
 */
class ViisonCommon_Plugin_BootstrapV5 extends ViisonCommon_Plugin_BootstrapV4
{
    /**
     * Update the translations of the plugin's config form.
     *
     * The label of the config form is read from 'plugin.json', the description is read from 'description.xx.html', and
     * the labels and descriptions of the individual config form elements are read from 'form.ini'.
     *
     * Call this method once after a successful plugin update.
     */
    protected function updateConfigFormTranslations()
    {
        $configFormInstallationHelper = new ConfigFormInstallationHelper($this->get('models'));

        // Set the form label and description for each defined language
        $form = $this->Form();
        $pluginInfo = json_decode(file_get_contents($this->Path() . 'plugin.json'), true);
        foreach ($pluginInfo['label'] as $language => $label) {
            $localeIdentifier = LocalizationUtil::getPrimaryLocaleForLanguage($language);
            $descriptionFilename = $this->Path() . 'description.' . $language . '.html';
            $description = null;
            if (file_exists($descriptionFilename)) {
                $description = file_get_contents($descriptionFilename);
            }
            $configFormInstallationHelper->setFormTranslation($form, $localeIdentifier, $label, $description);
        }

        // Set translations for the config forms
        $configFormInstallationHelper->updateElementTranslations($form, $this->Path() . 'form.ini');
    }
}
