<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Subscribers;

use Shopware\Plugins\ViisonCommon\Components\SubApplicationLoading\AbstractSubApplicationRegistrationSubscriber;

class SubApplicationRegistrationSubscriber extends AbstractSubApplicationRegistrationSubscriber
{
    /**
     * @inheritdoc
     */
    public function getPluginPath()
    {
        return __DIR__ . '/../';
    }

    /**
     * @inheritdoc
     */
    public function createSubApplications()
    {
        $this->addModelExtension('ViisonCommonBaseModelExtensions')->extendingSubApplication('Base');

        $this->addSubApplication('ViisonCommonComboBox');
        $this->addSubApplication('ViisonCommonCurrencyFormatter');
        $this->addSubApplication('ViisonCommonData');
        $this->addSubApplication('ViisonCommonEventBus');
        $this->addSubApplication('ViisonCommonHintPanel');
        $this->addSubApplication('ViisonCommonGrid');
        $this->addSubApplication('ViisonCommonGridLabelPrinting');
        $this->addSubApplication('ViisonCommonIndexPopup');
        $this->addSubApplication('ViisonCommonMailComposer');
        $this->addSubApplication('ViisonCommonPaginationToolbar');
        $this->addSubApplication('ViisonCommonShopwareVersion');
        $this->addSubApplication('ViisonCommonStatusTranslator');
        $this->addSubApplication('ViisonCommonVariantComboBox')->requiringSubApplication('ViisonCommonComboBox');

        $this->addSubApplicationExtension('ViisonCommonAnalytics')->extendingSubApplication('Analytics');
        $this->addSubApplicationExtension('ViisonCommonCompatibilityCheck')->extendingSubApplication('Index');
        $this->addSubApplicationExtension('ViisonCommonConfigDocument')->extendingSubApplication('Config');
        $this->addSubApplicationExtension('ViisonCommonMigration')->extendingSubApplication('Index');
        $this->addSubApplicationExtension('ViisonCommonOrderActivityPerformedDate')->extendingSubApplication('Order');
        $this->addSubApplicationExtension('ViisonCommonOrderDocumentTypeHider')->extendingSubApplication('Order');
    }
}
