// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonAnalytics.controller.FilterModule.DefaultShopFactory', {

    getToolbarComponentValueRetriever: function () {
        return function (toolbar) {
            var selectedShops = toolbar.child('[name=shop_selection]').getValue();
            if (selectedShops === undefined || selectedShops === null) {
                return selectedShops;
            }

            return selectedShops.join(',');
        };
    },

    getToolbarFilterConfig: function () {
        return {
            componentConfig: {
                name: 'shop_selection',
                isDefault: true,
            },
        };
    },

});
