// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonCompatibilityCheck.view.Menu', {

    override: 'Shopware.apps.Index.view.Menu',

    /* @Override */
    initComponent: function () {
        // Trigger the compatibility check 500 ms after the menu was created
        this.on('menu-created', function () {
            window.setTimeout(this.viisonCommonPerformCompatibilityCheck.bind(this), 500);
        }, this);

        return this.callParent(arguments);
    },

    /**
     * Checks for any plugin compatibility issues and displays them
     * as growl messages.
     */
    viisonCommonPerformCompatibilityCheck: function () {
        Ext.Ajax.request({
            url: ViisonCommonApp.assembleBackendUrl('ViisonCommonCompatibilityCheck/getCompatibilityIssues'),
            scope: this,
            success: function (response) {
                var responseData = Ext.JSON.decode(response.responseText, true);
                if (!responseData.success) {
                    return;
                }

                // Display compatibility issues as growl message.
                // Each issue is displayed in its own growl message
                var compatibilityIssues = responseData.data;
                if (compatibilityIssues !== null) {
                    Ext.Array.forEach(compatibilityIssues, function (growl) {
                        Shopware.Notification.createStickyGrowlMessage({
                            title: ViisonCommonApp.getSnippet('check/notification/title', 'backend/viison_common_compatibility_check/main'),
                            text: growl.message,
                            // Add additional button if link and title are given
                            btnDetail: (growl.detailButton) ? {
                                text: growl.detailButton.title,
                                callback: function () {
                                    // Open the link
                                    window.open(growl.detailButton.link, '_blank');
                                },
                            } : '',
                        });
                    }, this);
                }
            },
        });
    },

});
