// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonGridLabelPrinting.view.TemplateChooser', {

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_common_grid_label_printing/main',

    createTemplateComponents: function () {
        // Create the template store
        this.templateStore = Ext.create(this.templateClass, {});

        // Create the template selection
        this.templateSelection = Ext.create('Ext.form.field.ComboBox', {
            fieldLabel: this.getViisonSnippet('template_chooser/fields/template/label'),
            name: 'template',
            store: this.templateStore,
            queryMode: 'local',
            displayField: 'title',
            valueField: 'name',
            width: 340,
            editable: false,
            allowBlank: false,
            listeners: {
                scope: this,
                select: function (comboBox, records) {
                    // Update the max values of the start position fields
                    this.resetStartPositionFields(records[0]);
                },
            },
        });

        // Create the start position fields
        this.startYField = Ext.create('Ext.form.field.Number', {
            fieldLabel: this.getViisonSnippet('template_chooser/fields/start_y/label'),
            helpText: this.getViisonSnippet('template_chooser/fields/start_y/help'),
            name: 'startY',
            value: 1,
            minValue: 1,
            maxValue: 16,
            allowDecimals: false,
            anchor: '100%',
        });

        this.startXField = Ext.create('Ext.form.field.Number', {
            fieldLabel: this.getViisonSnippet('template_chooser/fields/start_x/label'),
            helpText: this.getViisonSnippet('template_chooser/fields/start_x/help'),
            name: 'startX',
            value: 1,
            minValue: 1,
            maxValue: 5,
            allowDecimals: false,
            anchor: '100%',
        });

        // Load the templates
        this.templateStore.load({
            scope: this,
            callback: function (records) {
                // Select the default element
                for (var i = 0; i < records.length; i += 1) {
                    if (records[i].get('default')) {
                        // Update the selection
                        this.templateSelection.setValue(records[i].get('name'));
                        // Update the max values of the start position fields
                        this.resetStartPositionFields(records[i]);
                        break;
                    }
                }
            },
        });
    },

    /**
     * Updates the maximum values of the start position fields and, in case
     * a currently selected value exceeds these limits, resets both fields to one.
     *
     * @param record The newly selected GridLabelTemplate record.
     */
    resetStartPositionFields: function (record) {
        // Update the maximum values
        this.startYField.setMaxValue(record.get('numRows'));
        this.startXField.setMaxValue(record.get('numCols'));
        if (this.startYField.getValue() > record.get('numRows') || this.startXField.getValue() > record.get('numCols')) {
            // Reset the values
            this.startXField.setValue(1);
            this.startYField.setValue(1);
        }
    },

});
