// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonIndexPopup.view.Window', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_commmon_index_popup-window',
    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    border: false,
    autoShow: true,
    width: 620,
    height: '90%',
    layout: 'border',
    viisonSnippetNamespace: 'backend/viison_common_index_popup/main',

    /**
     * @Override
     */
    initComponent: function () {
        // Create docker toolbar
        this.hideDialogInTheFutureCheckbox = Ext.create('Ext.form.field.Checkbox', {
            xtype: 'checkbox',
            name: 'hideDialogInTheFuture',
            value: false,
            uncheckedValue: false,
            inputValue: true,
            labelWidth: 220,
            labelSeparator: '',
            hideLabel: true,
            boxLabel: this.getViisonSnippet('window/toolbar/hide_dialog_in_the_future'),
            fieldLabel: this.getViisonSnippet('window/toolbar/hide_dialog_in_the_future'),
        });
        var okButton = Ext.create('Ext.button.Button', {
            text: this.getViisonSnippet('window/toolbar/ok_button'),
            cls: 'primary',
            action: 'closeWindow',
            scope: this,
            handler: function () {
                this.fireEvent('closeWindow', this);
            },
        });
        this.dockedItems = [
            Ext.create('Ext.toolbar.Toolbar', {
                dock: 'bottom',
                ui: 'shopware-ui',
                cls: 'shopware-toolbar',
                items: [
                    this.hideDialogInTheFutureCheckbox,
                    '->',
                    okButton,
                ],
            }),
        ];

        this.callParent(arguments);
    },

    /**
     * Updates the width of this window and centers it in its parent viewport.
     */
    setWidth: function () {
        this.callParent(arguments);
        this.center();
    },

    /**
     * Replaces all view items with a new label that renders the given HTML.
     *
     * @param html
     */
    setContentHTML: function (html) {
        this.removeAll();
        this.add(Ext.create('Ext.form.Label', {
            region: 'north',
            html: html,
            style: {
                whiteSpace: 'normal',
                height: '100%',
                overflowY: 'auto',
            },
        }));
    },

    /**
     * Sends an ajax request to the given URL to send the correct CSRF token,
     * in case the url points to the Shopware backend. Finally the responded HTML
     * is used as the source for a new iframe component, which is added as the only
     * element to this window.
     *
     * @param url
     */
    setContentURL: function (url) {
        Ext.Ajax.request({
            url: url,
            scope: this,
            success: function (response) {
                this.removeAll();
                this.add(Ext.create('Ext.Component', {
                    region: 'north',
                    autoEl: {
                        tag: 'iframe',
                        src: 'data:text/html;charset=utf-8,' + encodeURIComponent(response.responseText),
                    },
                }));
            },
        });
    },

});
