// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonMigration.model.ManifestedMigration', {
    extend: 'Ext.data.Model',
    alternateClassName: 'ViisonManifestedMigration',

    statics: {
        STATUS_COMPLETED: 'completed',
        STATUS_FAILED: 'failed',
        STATUS_PENDING: 'pending',
    },

    fields: [
        { name: 'migrationSetId', type: 'int' },
        { name: 'name', type: 'string' },
        { name: 'status', type: 'string' },
        { name: 'canExecute', type: 'boolean' },
        { name: 'exceptionMessage', type: 'string', useNull: true },
        { name: 'exceptionDetails', type: 'string', useNull: true },
    ],
});
