// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonMigration.model.MigrationSet', {
    extend: 'Ext.data.Model',

    fields: [
        { name: 'id', type: 'int' },
        { name: 'migrationExecutionResultId', type: 'int', useNull: true, default: null },
        { name: 'name', type: 'string' },
        { name: 'hasExecutableMigrations', type: 'boolean' },
    ],

    associations: [{
        type: 'hasMany',
        model: 'Shopware.apps.ViisonCommonMigration.model.ManifestedMigration',
        associationKey: 'migrations',
        name: 'getMigrations',
        foreignKey: 'migrationSetId',
        primaryKey: 'id',
    }],

    /**
     * @returns {Shopware.apps.ViisonCommonMigration.model.ManifestedMigration[]}
     */
    getExecutableMigrations: function () {
        return this.getMigrations().getRange().filter(function (migration) {
            return migration.get('canExecute');
        });
    },

    /**
     * @returns {Shopware.apps.ViisonCommonMigration.model.ManifestedMigration}
     */
    getFailedMigration: function () {
        var failedMigration = null;
        this.getMigrations().getRange().forEach(function (migration) {
            if (migration.get('status') === ViisonManifestedMigration.STATUS_FAILED) {
                failedMigration = migration;

                return false;
            }

            return true;
        });

        return failedMigration;
    },
});
