// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonMigration.store.MigrationExecutionResult', {
    extend: 'Ext.data.Store',

    model: 'Shopware.apps.ViisonCommonMigration.model.MigrationExecutionResult',

    /**
     * @override
     */
    loadData: function (MigrationExecutionResultData, append) {
        if (!append) {
            this.removeAll();
        }

        MigrationExecutionResultData.forEach(function (migrationExecutionResultData) {
            var migrationExecutionResult = Ext.create(this.model, migrationExecutionResultData);
            migrationExecutionResult.getMigrationSetsStore = Ext.create(
                'Shopware.apps.ViisonCommonMigration.store.MigrationSet'
            );
            migrationExecutionResult.getMigrationSets().loadData(migrationExecutionResultData.migrationSets);
            this.add(migrationExecutionResult);
        }, this);
    },
});
